# Proyecto 4. La gran aventura del mar encantado

*“La mañana empezó mal para la Princesa: el Caballero Negro había secuestrado al Príncipe 
y ella aún no había arreglado las cosas con el Mago. 
Hacía dos días había discutido con el Mago, y le había sacado su sombrero mágico, escondiéndolo en un cofre. 
Pero el Mago era el único que podía darle la espada encantada que le iba a permitir vencer al Caballero Negro. 
La cosa no podía quedar así: tenía que salvar al Príncipe. 
Y cumplir juntos el sueño de pasear en Unicornio”*

Tenés que escribir un programa que cuente la historia de *“La gran aventura del mar encantado”*. 
La idea es ayudar a una princesa a rescatar a su príncipe. 
Para hacerlo tiene que cumplir con una serie de tareas, en orden. 
Primero tiene que buscar la llave; cuando la tenga, la tiene que usar para abrir el cofre y sacar el 
sombrero mágico; luego le cambia el sombrero mágico al mago por la espada encantada, y con la espada va
a atacar al caballero, cumpliendo su misión de rescate; la aventura termina cuando la protagonista lleva 
al príncipe hasta el unicornio y escapan juntos.

<center>
![Tablero inicial con vestimenta](data:image/png;base64,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)
</center>

Para contar la historia, lo mejor es escribir un procedimiento para cada parte. 
Para que no te preocupes por la representación, en el proyecto ya están hechos los procedimientos 
primitivos que te permiten hacer las acciones básicas y la vestimenta para que veas la historia con 
imágenes, y no con bolitas; vos solamente tenés que contar la historia. 
Tenés que tener cuidado: si la princesa se cae o pasa por alguno de los lugares de las pruebas sin tener 
los elementos necesarios, el programa va a fallar. 

> **El dato**
>
> Si bien podés resolverlo sin procedimientos, lo interesante es que el programa resultante se lea como una 
> historia. Vos tenés que elegir bien los nombres de los procedimientos para que esto sea así. Por ejemplo, para la primera prueba podés hacer un procedimiento IrALaLlave, y otro BuscarLaLlave que use al procedimiento anterior para ir a la llave y agarrarla.

Los procedimientos, además de ayudar a que los programas sean más cortos y fáciles de modificar, también 
hacen que el programa sea más fácil de entender, al permitir expresar la solución utilizando el vocabulario 
del problema. 
Si los procedimientos se eligen y nombran bien, cualquier persona que lea el programa podrá entender cuál 
fue la intención de quien lo programó, cuál es el problema y cómo se soluciona.

[Enunciado en PDF][PDF]

[PDF]: https://raw.githubusercontent.com/gobstones/curso-InPr-UNQ/master/Proyectos/2.Procedimientos/4.La%20gran%20aventura%20del%20mar%20encantado/assets/resources/description.pdf "Enunciado de 'La gran aventura del mar encantado' en PDF"
